<?php
if (!defined('_GNUBOARD_')) exit; //개별 페이지 접근 불가

// 옵션
$wos = apms_options($options, $m_options);
$slide = (int)$wos['slide'];
$item_rows = (int)$wos['slide_garo'];

$slide = ($slide > 0) ? $slide : 1;

//아이템수에 따른 칼럼 계산
switch($item_rows) {
	case '1'	: $item_cols = 12; break;
	case '2'	: $item_cols = 6; break;
	case '3'	: $item_cols = 4; break;
	case '4'	: $item_cols = 3; break;
	case '6'	: $item_cols = 2; break;
	default		: $item_cols = 3; $item_rows = 4; break;
}

// 총추출수
$wos['rows'] = $slide * $item_rows;

$list = apms_banner_event_rows($wos);
$list_cnt = count($list);
if(!$list_cnt) {
	echo '<p class="text-muted text-center">등록된 이벤트가 없습니다.</p>'.PHP_EOL;
	return;
}

// 효과
switch($wos['carousel']) {
	case 'fade'		: $effect = ' slide at-fade'; break;
	case 'up'		: $effect = ' slide at-vertical'; break;
	case 'slide'	: $effect = ' slide'; break;
	case 'show'		: $effect = ''; break;
	default			: $effect = ' slide'; break;
}

// 효과시간
$interval = ($wos['interval']) ? $wos['interval'] : 5000;

// Random Ticker Id
$carousel_id = apms_id();

// 이미지 비율
$img_height = ($wos['thumb_w'] > 0 && $wos['thumb_h'] > 0) ? round(($wos['thumb_h'] / $wos['thumb_w']) * 100, 2) : 56.25;

?>

<div class="carousel<?php echo $effect;?> widget-carousel" id="<?php echo $carousel_id;?>" data-ride="carousel" data-interval="<?php echo $interval;?>">

	<div class="carousel-nav">
		<a class="left" href="#<?php echo $carousel_id;?>" role="button" data-slide="prev"><i class="fa fa-angle-left"></i></a>
		<a class="right" href="#<?php echo $carousel_id;?>" role="button" data-slide="next"><i class="fa fa-angle-right"></i></a>
	</div>

	<!-- Wrapper for slides -->
	<div class="carousel-inner">
		<div class="item active">
			<div class="row">
				<?php for($i=0; $i < $list_cnt; $i++) { ?>
					<?php if($i > 0 && $i%$item_rows == 0) { ?>
							</div>
						</div>
						<div class="item">
							<div class="row">
					<?php } ?>
						<div class="col-sm-<?php echo $item_cols;?>">
							<div class="img" style="padding-bottom:<?php echo $img_height;?>%;">
								<a href="<?php echo $list[$i]['href'];?>">
									<img src="<?php echo $list[$i]['img'];?>" alt="<?php echo $list[$i]['alt'];?>">
								</a>
							</div>
						</div>
				<?php } ?>
			</div>
		</div>
	</div>
</div>
